-- View: basis_view

 DROP VIEW basis_view;

CREATE OR REPLACE VIEW basis_view AS 
 SELECT b.id, b.naam AS plannaam, g.naam AS gemeente, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 1 AND bv.bouwplanid = b.id) AS voortgang, b.prognose_oplevering AS oplevering, ( SELECT sum(factmetperiode.planningaantal) AS sum
           FROM factmetperiode
          WHERE factmetperiode.bouwplanid = b.id AND factmetperiode.factsoortid <> 1 AND factmetperiode.factsoortid <> 2 AND factmetperiode.factsoortid <> 19 AND factmetperiode.factsoortid <> 27) AS "gepland nieuwbouw", ( SELECT sum(factmetperiode.planningaantal) AS sum
           FROM factmetperiode
          WHERE factmetperiode.bouwplanid = b.id AND (factmetperiode.factsoortid = 3 OR factmetperiode.factsoortid = 6 OR factmetperiode.factsoortid = 9 OR factmetperiode.factsoortid = 4 OR factmetperiode.factsoortid = 7 OR factmetperiode.factsoortid = 10 OR factmetperiode.factsoortid = 12 OR factmetperiode.factsoortid = 14 OR factmetperiode.factsoortid = 16)) AS "gepland sociaal", ( SELECT sum(factmetperiode.planningaantal) AS sum
           FROM factmetperiode
          WHERE factmetperiode.bouwplanid = b.id AND factmetperiode.factsoortid = 2) AS "gepland sloop"
   FROM bouwplan b
   LEFT JOIN gemeente g ON b.gemeenteid = g.id
   LEFT JOIN statusplanologisch s ON b.statusplanologischid = s.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE basis_view OWNER TO rwbp;

-- View: gepland_view

DROP VIEW gepland_view;


CREATE OR REPLACE VIEW gepland_view AS 
 SELECT p.bouwplanid AS id, p.periodeid, p.periodeomschrijving AS omschrijving, sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_t, max(
        CASE
            WHEN p.factsoortid = 3 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_g, max(
        CASE
            WHEN p.factsoortid = 5 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_m, max(
        CASE
            WHEN p.factsoortid = 21 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_o, max(
        CASE
            WHEN p.factsoortid = 4 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_s, max(
        CASE
            WHEN p.factsoortid = 6 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_g, max(
        CASE
            WHEN p.factsoortid = 8 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_m, max(
        CASE
            WHEN p.factsoortid = 22 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_o, max(
        CASE
            WHEN p.factsoortid = 7 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_s, max(
        CASE
            WHEN p.factsoortid = 9 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_g, max(
        CASE
            WHEN p.factsoortid = 11 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_m, max(
        CASE
            WHEN p.factsoortid = 23 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_o, max(
        CASE
            WHEN p.factsoortid = 10 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_s, max(
        CASE
            WHEN p.factsoortid = 13 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_m, max(
        CASE
            WHEN p.factsoortid = 24 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_o, max(
        CASE
            WHEN p.factsoortid = 12 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_s, max(
        CASE
            WHEN p.factsoortid = 15 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_m, max(
        CASE
            WHEN p.factsoortid = 25 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_o, max(
        CASE
            WHEN p.factsoortid = 14 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_s, max(
        CASE
            WHEN p.factsoortid = 17 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_m, max(
        CASE
            WHEN p.factsoortid = 26 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_o, max(
        CASE
            WHEN p.factsoortid = 16 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_s, max(
        CASE
            WHEN p.factsoortid = 18 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_o, max(
        CASE
            WHEN p.factsoortid = 2 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_s
   FROM planningaantal_per_soort_per_periode_per_bouwplan p
  GROUP BY p.bouwplanid, p.periodeomschrijving, p.periodeid
  ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gepland_view OWNER TO rwbp;



-- View: info_view

DROP VIEW info_view;

CREATE OR REPLACE VIEW info_view AS 
 SELECT b.id, b.the_geom, b.naam AS plannaam, b.aanduidingid, ( SELECT v.voortgangstatusid
           FROM bouwplanvoortgang v
          WHERE v.bouwplanid = b.id AND v.voortgangsoortid = 1) AS voortgangid, g.naam AS gemeente, to_char(b.prognose_start, 'DD-MM-YYYY'::text) AS prognose_start, to_char(b.prognose_oplevering, 'DD-MM-YYYY'::text) AS prognose_oplevering, ( SELECT vs.type
           FROM bouwplanvoortgang v
      LEFT JOIN voortgangstatus vs ON v.voortgangstatusid = vs.id
     WHERE v.bouwplanid = b.id AND v.voortgangsoortid = 1) AS voortgang, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid = 2) AS tweeduizendnegen, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid >= 3 AND f.periodeid <= 7) AS tweeduizendtien_veertien, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid >= 8 AND f.periodeid <= 12) AS tweeduizendveertien_negentien, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid = 13) AS tweeduizendtwintig, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid = 17) AS onbekend, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19) AS totaal
   FROM bouwplan b
   LEFT JOIN gemeente g ON b.gemeenteid = g.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL AND b.gebruikgegevensid = 1
  ORDER BY b.id;

ALTER TABLE info_view OWNER TO rwbp;


-- View: shape_view

DROP VIEW shape_view;

CREATE OR REPLACE VIEW shape_view AS 
 SELECT b.the_geom, b.id, b.naam AS plannaam, g.naam AS gemeente, r.naam AS regio, b.gebruikeractiontijd AS "laatste wijziging", ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27) AS "aantal gepland"
   FROM bouwplan b
   LEFT JOIN gemeente g ON g.id = b.gemeenteid
   LEFT JOIN regio r ON r.id = g.regioid
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE shape_view OWNER TO rwbp;

-- View: stedenbaan_shape_view

DROP VIEW stedenbaan_shape_view;

CREATE OR REPLACE VIEW stedenbaan_shape_view AS 
 SELECT p.the_geom, p.id, p.laatste_wijziging, p.soort, p.plannaam, p.referentie, p.bestemmingsplan, p.masterplan, p.invloedsgebied, p.gemeente, p.regio, p.opdrachtgever, p.opdrachtgever_naam, p.aanduiding, p.plantype, p.gebruik_gegevens, p.prognose_start_bouw, p.status_planologisch, p.status_project, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 2 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2009, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 3 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2010, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 4 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2011, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 5 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2012, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 6 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2013, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 7 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2014, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 8 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2015, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 9 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2016, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 10 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2017, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 11 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2018, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 12 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2019, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 13 THEN p.aantal
            ELSE NULL::integer
        END) AS n_2020ev, max(
        CASE
            WHEN p.factsoortid = 1 AND p.periodeid = 17 THEN p.aantal
            ELSE NULL::integer
        END) AS n_onbekend, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 2 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2009, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 3 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2010, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 4 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2011, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 5 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2012, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 6 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2013, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 7 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2014, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 8 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2015, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 9 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2016, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 10 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2017, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 11 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2018, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 12 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2019, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 13 THEN p.aantal
            ELSE NULL::integer
        END) AS s_2020ev, max(
        CASE
            WHEN p.factsoortid = 2 AND p.periodeid = 17 THEN p.aantal
            ELSE NULL::integer
        END) AS s_onbekend, p.opmerking_openbaar, p.opmerking_gemeente
   FROM aantal_per_soort_per_periode_per_plan p
  GROUP BY p.id, p.the_geom, p.laatste_wijziging, p.soort, p.plannaam, p.referentie, p.bestemmingsplan, p.masterplan, p.invloedsgebied, p.gemeente, p.regio, p.opdrachtgever, p.opdrachtgever_naam, p.aanduiding, p.plantype, p.gebruik_gegevens, p.prognose_start_bouw, p.status_planologisch, p.status_project, p.opmerking_openbaar, p.opmerking_gemeente
  ORDER BY p.id;

ALTER TABLE stedenbaan_shape_view OWNER TO rwbp;
-- View: test_sum

DROP VIEW test_sum;

CREATE OR REPLACE VIEW test_sum AS 
 SELECT b.id AS bouwplanid, p.id AS periodeid, p.omschrijving AS periodeomschrijving, sum(fmt.planningaantal) AS sum
   FROM bouwplan b, periode p, factmetperiode fmt
  WHERE fmt.bouwplanid = b.id AND fmt.periodeid = p.id AND fmt.factsoortid <> 1 AND fmt.factsoortid <> 2 AND fmt.factsoortid <> 19 AND fmt.factsoortid <> 27
  GROUP BY p.id, p.omschrijving, b.id
  ORDER BY p.id, p.omschrijving;

ALTER TABLE test_sum OWNER TO rwbp;



